chrome.runtime.onMessage.addListener((request, sender, sendResponse) => {
  if (request.action === 'getAllVideos') {
    const videos = document.querySelectorAll('video');
    const videoList = [];

    videos.forEach((v, i) => {
      // 尝试获取视频源
      const src = v.src || v.querySelector('source')?.src || '';
      if (src) {
        videoList.push({
          index: i + 1,
          src: src
        });
      }
    });

    sendResponse({ videos: videoList });
  }
});
