document.getElementById('detectVideos').addEventListener('click', () => {
  chrome.tabs.query({ active: true, currentWindow: true }, (tabs) => {
    chrome.tabs.sendMessage(tabs[0].id, { action: 'getAllVideos' }, (response) => {
      const list = document.getElementById('videoList');
      list.innerHTML = ''; // 清空旧内容

      const videos = response?.videos || [];

      if (videos.length === 0) {
        list.innerHTML = '<p>未检测到视频。</p>';
        return;
      }

      videos.forEach((v) => {
        const div = document.createElement('div');
        div.className = 'video-item';
        div.innerHTML = `
          <p><strong>视频 ${v.index}</strong></p>
          <div class="video-src">${v.src}</div>
          <button class="download-btn">下载</button>
          <button class="copy-btn">复制链接</button>
        `;

        // 下载事件
        div.querySelector('.download-btn').addEventListener('click', () => {
          chrome.downloads.download({
            url: v.src,
            filename: `video_${v.index}.mp4`
          });
        });

        // 复制事件
        div.querySelector('.copy-btn').addEventListener('click', () => {
          navigator.clipboard.writeText(v.src);
          div.querySelector('.copy-btn').textContent = '已复制';
          setTimeout(() => {
            div.querySelector('.copy-btn').textContent = '复制链接';
          }, 1000);
        });

        list.appendChild(div);
      });
    });
  });
});
